<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index()
    {
        $salesData = \App\Models\ProfitGraphmodel::getLast30DaysData();
        $all_settings = \App\Models\Setting::first() ?? (object) ['currency' => 'USD'];
        $tenantId = auth()->user()->tenant_id;
        
        // Calculate total sales (Direct Sales + Regular Sales)
        $totalDirectSales = \App\Models\DirectSales::where('tenant_id', $tenantId)
                                                  ->sum(DB::raw('direct_sell_price * direct_sold_quantity'));
        
        $totalRegularSales = \App\Models\SellTransaction::where('tenant_id', $tenantId)
                                                        ->sum(DB::raw('sell_price * sold_quantity'));
        
        $completeSale = $totalDirectSales + $totalRegularSales;
        
        // Calculate total profit (Direct Profit + Regular Profit)
        $totalDirectProfit = \App\Models\DirectSales::where('tenant_id', $tenantId)
                                                   ->sum('direct_profit');
        
        $totalRegularProfit = \App\Models\SellTransaction::where('tenant_id', $tenantId)
                                                         ->sum('profit');
        
        $completeProfit = $totalDirectProfit + $totalRegularProfit;
        
        // Calculate today's due amount from sales created today
        $todayDueAmount = \App\Models\Sale::where('tenant_id', $tenantId)
                                         ->whereDate('created_at', today())
                                         ->sum('due_amount');
        
        // Calculate yesterday's due amount from sales created yesterday
        $yesterdayDueAmount = \App\Models\Sale::where('tenant_id', $tenantId)
                                             ->whereDate('created_at', today()->subDay())
                                             ->sum('due_amount');
        
        // Calculate today's expenses
        $todayExpenses = \App\Models\Expense::where('tenant_id', $tenantId)
                                           ->whereDate('expense_date', today())
                                           ->sum('amount');
        
        return view('home', compact('salesData', 'all_settings', 'todayDueAmount', 'yesterdayDueAmount', 'completeSale', 'completeProfit', 'todayExpenses'));
    }

    public function getDueAmountByDateRange(Request $request)
    {
        $startDate = $request->start_date;
        $endDate = $request->end_date;
        
        $dueAmount = \App\Models\Sale::where('tenant_id', auth()->user()->tenant_id)
                                    ->whereBetween('created_at', [$startDate, $endDate])
                                    ->sum('due_amount');
        
        return response()->json([
            'due_amount' => $dueAmount
        ]);
    }
}
